﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Urlopy - plan</title>
		<script runat="server">

    public class PrnParams : ContextBase {

        public PrnParams(Context context): base(context) {
            stanNaDzień = ((ActualDate)Context[typeof(ActualDate)]).Actual;
        }
                
        Date stanNaDzień;
        [Priority(10)]
        [Caption("Stan na dzień")]
        public Date StanNaDzień {
            get { return stanNaDzień; }
        }
    }

    PrnParams pars = null;
    [Context(Required = true)]
    public PrnParams Params {
        set { pars = value; }
    }

    DefinicjaLimitu definicja;
	KalendModule kalend;
	
	void OnContextLoad(Object sender, EventArgs args) {
        kalend = KalendModule.GetInstance(dc);
        definicja = kalend.DefinicjeLimitow.WgNazwy["Urlop wypoczynkowy prac.tymcz."];

        ReportHeader1["DATA"] = pars.StanNaDzień.ToString();
        ReportHeader1["DEFINICJA"] = definicja.Nazwa;
	}

    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        PracHistoria ph = (PracHistoria)args.Row;
        
        if (ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowy &&
            ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowyZaGranicą) {
            args.VisibleRow = false;
            return;
        }

        int limit = 0;
        int wykorzystany = 0;
        FromTo okres = FromTo.Empty;
        LimitNieobecnosci l = (LimitNieobecnosci)kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][pars.StanNaDzień];
        if (l != null) {
            limit = l.Razem;
            okres = l.Okres;
        }
        
        KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
        FromTo okresNie = new FromTo(Date.MinValue, pars.StanNaDzień);
        foreach (OkresNieobecności n in kalk.Nieobecnosci(okresNie * ph.Etat.OkresZatrudnienia, true))
            if (n.Definicja.Limit == definicja) {
                Nieobecnosc no = (Nieobecnosc)n;
                int dni;
                if (no.Okres.Days == 1)
                    dni = no.Okres.Days;
                else
                    dni = kalk.Plan.Norma(n.Okres).Dni;
                if (!okres.Contains(n.Okres))
                    limit += dni;
                wykorzystany += dni;
            }

        limitO.EditValue = okres;
        urlopG.EditValue = Formatuj(limit);
        urlopW.EditValue = Formatuj(wykorzystany);
        urlopP.EditValue = Formatuj(limit - wykorzystany);
    }

    string Formatuj(int dni) {
        if (dni == 0)
            return "";
        return string.Format("{0}", dni);
    }
		            
	public static object Msg(object obj) {
		return obj;
	}

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body> 
		<form id="UrlopyPlan" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"
				oncontextload="OnContextLoad" Landscape="False"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="Wykorzystanie urlopów|</strong>Definicja: <strong>%DEFINICJA%|</strong>Wg stanu na dzień: <strong>%DATA%" 
                runat="server"></cc1:reportheader>
            <ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"
				LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="Etat.Wydzial.Kod" Caption="Nazwa działu zakładu pracy" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="prac" DataMember="Pracownik.NazwiskoImię" 
                        Caption="Nazwisko i imię pracownika" NoWrap="True" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn ID="limitO" runat="server" Align="Left" Caption="Limit w okresie"
                        Width="22">
                    </ea:GridColumn>
                    <ea:GridColumn ID="urlopG" runat="server" Align="Center" Caption="Wymiar"
                        HideZero="True" Width="10">
                    </ea:GridColumn>
					<ea:GridColumn runat="server" Caption="Wykorzystany" 
                        HideZero="True" ID="urlopW" Align="Center" Width="12">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Pozostaje" HideZero="True" 
                        ID="urlopP" Align="Center" Width="10">
                    </ea:GridColumn>
				</Columns>
			</ea:grid>
            <cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
